<?php
include 'includes/header.php';
require_once '../config/database.php';

$database = new Database();
$db = $database->getConnection();

if (isset($_POST['add_code'])) {
    $brand_id = $_POST['brand_id'];
    $model_id = $_POST['model_id'];
    $code = sanitize_input($_POST['code']);
    $years = sanitize_input($_POST['years']);
    $description = sanitize_input($_POST['description']);

    $query = "INSERT INTO model_codes (brand_id, model_id, code, years, description) 
              VALUES (?, ?, ?, ?, ?)";
    $stmt = $db->prepare($query);
    
    if ($stmt->execute([$brand_id, $model_id, $code, $years, $description])) {
        set_message('Model code added successfully');
    } else {
        set_message('Error adding model code', 'danger');
    }
}

// Get all model codes with brand and model names
$codes_query = "SELECT mc.*, b.name as brand_name, m.name as model_name 
                FROM model_codes mc 
                JOIN brands b ON mc.brand_id = b.id 
                JOIN models m ON mc.model_id = m.id 
                ORDER BY b.name, m.name, mc.code";
$codes = $db->query($codes_query)->fetchAll();

// Get brands for dropdown
$brands_query = "SELECT * FROM brands ORDER BY name";
$brands = $db->query($brands_query)->fetchAll();
?>

<div class="container py-4">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h2>Manage Model Codes</h2>
                <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addCodeModal">
                    <i class="fas fa-plus"></i> Add Model Code
                </button>
            </div>

            <div class="card shadow">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Brand</th>
                                    <th>Model</th>
                                    <th>Code</th>
                                    <th>Years</th>
                                    <th>Description</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($codes as $code): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($code['brand_name']); ?></td>
                                    <td><?php echo htmlspecialchars($code['model_name']); ?></td>
                                    <td><?php echo htmlspecialchars($code['code']); ?></td>
                                    <td><?php echo htmlspecialchars($code['years']); ?></td>
                                    <td><?php echo htmlspecialchars($code['description']); ?></td>
                                    <td>
                                        <button class="btn btn-sm btn-primary edit-code" 
                                                data-id="<?php echo $code['id']; ?>">
                                            <i class="fas fa-edit"></i>
                                        </button>
                                        <button class="btn btn-sm btn-danger delete-code" 
                                                data-id="<?php echo $code['id']; ?>">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add Model Code Modal -->
<div class="modal fade" id="addCodeModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Add Model Code</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST">
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Brand</label>
                        <select name="brand_id" class="form-select" required>
                            <option value="">Select Brand</option>
                            <?php foreach ($brands as $brand): ?>
                                <option value="<?php echo $brand['id']; ?>">
                                    <?php echo htmlspecialchars($brand['name']); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Model</label>
                        <select name="model_id" class="form-select" required disabled>
                            <option value="">Select Brand First</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Code</label>
                        <input type="text" class="form-control" name="code" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Years</label>
                        <input type="text" class="form-control" name="years" 
                               placeholder="e.g., 2015-2020" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Description</label>
                        <textarea class="form-control" name="description" rows="3"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" name="add_code" class="btn btn-primary">Add Code</button>
                </div>
            </form>
        </div>
    </div>
</div> 